PACKAGE cluspack IS
  TYPE nineval IS (Z0, Z1, ZX,
                   R0, R1, RX,
                   F0, F1, FX );
  TYPE t_cluster IS ARRAY(0 to 15) OF nineval;
  TYPE t_clus_vec IS ARRAY(natural range <>) OF t_cluster;

  FUNCTION resolve_cluster( s: t_clus_vec ) RETURN t_cluster;

  SUBTYPE t_wclus IS resolve_cluster t_cluster;
  CONSTANT undriven : t_wclus;

END cluspack;



PACKAGE BODY cluspack IS
  CONSTANT undriven : t_wclus :=
           (ZX, ZX, ZX, ZX,
            ZX, ZX, ZX, ZX,
            ZX, ZX, ZX, ZX,
            ZX, ZX, ZX, ZX);

  FUNCTION resolve_cluster ( s: t_clus_vec ) return t_cluster IS
    VARIABLE result : t_cluster;
    VARIABLE drive_count : INTEGER;
  BEGIN
    IF s'LENGTH = 0 THEN RETURN undriven;
    END IF;
    FOR i in s'RANGE LOOP
      IF s(i) /= undriven THEN
        drive_count := drive_count + 1;
        IF drive_count = 1 THEN
          result := s(i);
        ELSE
          result := undriven;
          ASSERT FALSE
            REPORT "multiple drivers detected"
            SEVERITY ERROR;
        END IF;
      END IF;
    END LOOP;
    RETURN result;
  END resolve_cluster;
END cluspack;

